package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

/**
 * Enumeraatio säilytysaikaluokan arvoille.
 */
public enum SailytysaikaLuokka {

    // @formatter:off
    /**
     * Säilytysaikaluokat - koodisto 1.2.246.537.5.40158.2008 
     * 1 Pysyvästi säilytettävä 
     * 2 12 vuotta potilaan kuolemasta tai 120 vuotta syntymästä 
     * 3 12 vuotta asiakirjan syntymisestä tai hoitojakson päättymisestä 
     * 4 20 vuotta alaikäisen potilaan kuvantamistutkimuksesta 
     * 5 Hoitojakson ajan säilytettävät merkinnät ja asiakirjat 6 120 v. alle 1-vuotiaana kuolleen lapsen syntymästä
     */  
    LUOKKA_1("1"), 
    LUOKKA_2("2"), 
    LUOKKA_3("3"), 
    LUOKKA_4("4"), 
    LUOKKA_5("5"), 
    LUOKKA_6("6");
    // @formatter:on

    private final String value;


    /**
     * Privaatti konstruktori.
     * 
     * @param value arvo
     */
    private SailytysaikaLuokka(String value) {
	this.value = value;
    }


    /**
     * Palauttaa enumeraation arvon.
     * 
     * @return enumeraation arvo
     */
    public String getValue() {
	return value;
    }
}
