package fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit;

import java.beans.Transient;
import java.io.Serializable;

import fi.kela.kanta.ptayhteiset.tietomalli.vakiot.PTAYhteisetConstants;

/**
 * II-tyyppisten kenttien arvojen kuljettamiseen oleva objekti
 */
public class IIValue implements Serializable {

    private static final long serialVersionUID = 3235150672045508334L;

    private String root;
    private String extension;
    private NullFlavor nullflavor;


    /**
     * Palauttaa root attribuutin arvon.
     * 
     * @return root attribuutin arvo
     */
    public String getRoot() {
	return root;
    }


    /**
     * Root attribuutin arvon asetus.
     * 
     * @param root root attribuutti
     */
    public void setRoot(String root) {
	this.root = root;
    }


    /**
     * Palauttaa extension attribuutin arvon.
     * 
     * @return extension attribuutin arvo
     */
    public String getExtension() {
	return extension;
    }


    /**
     * Extension attribuutin arvon asetus.
     * 
     * @param extension extension attribuutti
     */
    public void setExtension(String extension) {
	this.extension = extension;
    }


    /**
     * Kertoo miksi elementti on tyhjä
     * 
     * @return Nullflavor
     */
    public NullFlavor getNullflavor() {
	return nullflavor;
    }


    /**
     * Asettaa null-tiedo
     * 
     * @param nullflavor elementin tyhjyyden syy
     */
    public void setNullflavor(NullFlavor nullflavor) {
	this.nullflavor = nullflavor;
    }


    /**
     * Tarkastaa, että kenttä on täytetty oikein
     * 
     * @return false, jos extensionissa on arvo, mutta rootissa ei
     */
    @Transient
    public boolean isValid() {
	return !((root == null || root.isEmpty()) && (extension != null && !extension.isEmpty()));
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

	String retValue = "";

	if ((root != null && !root.isEmpty()) && (extension != null && !extension.isEmpty())) {
	    retValue = new StringBuilder().append(root).append(PTAYhteisetConstants.SEPARATOR).append(extension).toString();
	} else if (root != null && !root.isEmpty()) {
	    retValue = root;
	} else if (nullflavor != null) {
	    retValue = nullflavor.getValue();
	}

	return retValue;
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
	final int prime = 31;
	int result = 1;
	result = prime * result + ((extension == null) ? 0 : extension.hashCode());
	result = prime * result + ((root == null) ? 0 : root.hashCode());
	return result;
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
	if (this == obj) {
	    return true;
	}
	if (obj == null) {
	    return false;
	}
	if (getClass() != obj.getClass()) {
	    return false;
	}
	IIValue other = (IIValue) obj;

	return this.toString().equals(other.toString());
    }

}
