package fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit;

/**
 * Luokka hakusanoman paluuvastauksen tietojen käyttöön.
 */
public class QueryAck {

    private String queryResponseCode;
    private IIValue queryId;
    private int resultTotalQuantity;
    private int resultCurrentQuantity;
    private int resultRemainingQuantity;


    /**
     * Palauttaa paluukoodin.
     * 
     * @return paluukoodi
     */
    public String getQueryResponseCode() {
	return queryResponseCode;
    }


    /**
     * Paluukoodin asetus.
     * 
     * @param queryResponseCode paluukoodi
     */
    public void setQueryResponseCode(String queryResponseCode) {
	this.queryResponseCode = queryResponseCode;
    }


    /**
     * Palauttaa kyselysanoman tunnisteen.
     * 
     * @return queryId kyselysanoman tunniste
     */
    public IIValue getQueryId() {
	return queryId;
    }


    /**
     * Kyselysanoman tunnisteen asetus.
     * 
     * @param queryId kyselysanoman tunniste
     */
    public void setQueryId(IIValue queryId) {
	this.queryId = queryId;
    }


    /**
     * Palauttaa tulosjoukon kokonaismäärän.
     * 
     * @return tulosjoukon kokonaismäärä
     */
    public int getResultTotalQuantity() {
	return resultTotalQuantity;
    }


    /**
     * Tulosjoukon kokonaismäärän asetus.
     * 
     * @param resultTotalQuantity tulosjoukon kokonaismäärä
     */
    public void setResultTotalQuantity(int resultTotalQuantity) {
	this.resultTotalQuantity = resultTotalQuantity;
    }


    /**
     * Palauttaa kyselyssä palautetun tulosten määrän.
     * 
     * @return kyselyssä palautetun tulosten määrä
     */
    public int getResultCurrentQuantity() {
	return resultCurrentQuantity;
    }


    /**
     * Kyselyssä palautetun tulosten määrän asetus.
     * 
     * @param resultCurrentQuantity kyselyssä palautetun tulosten määrä
     */
    public void setResultCurrentQuantity(int resultCurrentQuantity) {
	this.resultCurrentQuantity = resultCurrentQuantity;
    }


    /**
     * Palauttaa jäljellä olevien asiakirjojen määrän.
     * 
     * @return jäljellä olevien asiakirjojen määrä
     */
    public int getResultRemainingQuantity() {
	return resultRemainingQuantity;
    }


    /**
     * Jäljellä olevien asiakirjojen määrän asetus.
     * 
     * @param resultRemainingQuantity jäljellä olevien asiakirjojen määrä
     */
    public void setResultRemainingQuantity(int resultRemainingQuantity) {
	this.resultRemainingQuantity = resultRemainingQuantity;
    }


    @Override
    public String toString() {
	return "QueryAck [queryResponseCode=" + queryResponseCode + ", queryId=" + queryId + ", resultTotalQuantity=" + resultTotalQuantity + ", resultCurrentQuantity=" + resultCurrentQuantity + ", resultRemainingQuantity=" + resultRemainingQuantity + "]";
    }

}
