package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.LiiketoimintaHelper;
import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.LogUtils;
import fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit.IIValue;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

/**
 * Tarkastaa että hakuparametri-hetulle on annettu extension. Tulevaisuudessa mahdollista lisätä muototarkastus.
 */
public class HetuValidator implements ConstraintValidator<HetuConstraint, IIValue> {

    private static final Logger LOG = LoggerFactory.getLogger(HetuValidator.class);

    private boolean mustBeOfficial;

    @Override
    public void initialize(HetuConstraint annotation) {
	this.mustBeOfficial = annotation.mustBeOfficialHetu();
    }


    /**
     * Pakottaa extensionin, jos hetu virallinen (tarkastetaan rootista) tarkastetaan myös hetun muoto
     */
    @Override
    public boolean isValid(IIValue iiValue, ConstraintValidatorContext context) {
	LOG.trace(LogUtils.LOG_BEGIN);

	if (iiValue == null) {

	    LOG.trace(LogUtils.LOG_END);
	    return true;
	}

	if (!iiValue.isValid()) {

	    LOG.trace(LogUtils.LOG_END);
	    return false;
	}

	if (LiiketoimintaHelper.isOfficialHetu(iiValue)) {

	    boolean valid = LiiketoimintaHelper.validatePatientId(iiValue.getExtension());

	    LOG.trace(LogUtils.LOG_END);
	    return valid;

	} else if (mustBeOfficial) {

	    LOG.trace(LogUtils.LOG_END);
	    return false;

	} else {

	    LOG.trace(LogUtils.LOG_END);
	    return true;
	}
    }
}
