package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

/**
 * Enumeraatio IDKantaan asiakirjatyyppi arvoille.
 */
public enum AsiakirjaTyyppi {
 // @formatter:off
    ARKISTO_INFORMOINTI("1.2.246.537.6.12.2002.332"),
    ARKISTOASIAKIRJA("3"),
    B_TODISTUS("5"),
    ELINLUOVUTUS("1.2.246.537.6.12.2002.152"),
    HOITOTAHTO("1.2.246.537.6.12.2002.165"),
    INFORMOINTI("1.2.246.537.6.12.2002.332"),
    KANTA_INFORMOINTI("1.2.246.537.6.12.2002.339"),
    KERTOMUSTEKSTI("1"),
    KIELTO("1.2.246.537.6.12.2002.331"),
    KUVANTAMISTUTKIMUS("6"),
    LAAJA_KIELTO("1.2.246.537.6.12.2002.340"),
    LAUSUNTO_TODISTUS_LOMAKE("2"),
    LUOVUTUSILMOITUSASIAKIRJA("1.2.246.537.6.12.2002.322"),
    LUOVUTUSLUPA("1.2.246.537.6.12.2002.330"),
    OSTOPALVELUN_VALTUUTUS("1.2.246.537.6.12.2002.362"),
	PALVELUTAPAHTUMA_ASIAKIRJA("4"),
    PS_SUOSTUMUS("1.2.246.537.6.12.2002.504"),
    RESEPTI_KIELTO("1.2.246.537.6.12.2002.370"),
	YHTEYDENOTTO_KIELTO("1.2.246.537.6.12.2002.503");

    // @formatter:on

    private final String value;

    /**
     * Privaatti konstruktori.
     *
     * @param value arvo
     */
    private AsiakirjaTyyppi(String value) {
        this.value = value;
    }


    /**
     * Palauttaa enumeraation arvon.
     *
     * @return enumeraation arvo
     */
    public String getValue() {
        return value;
    }
}
