package fi.kela.kanta.ptayhteiset.tietomalli.vakiot;

import org.apache.commons.lang3.ArrayUtils;

import java.sql.Timestamp;
import java.util.regex.Pattern;

/**
 * Luokka palveluun liittyville vakioille
 */
public class PTAYhteisetConstants {

    public static final String UTF8 = "UTF-8";
    public static final String UTC = "UTC";
    public static final String EUROPE_HELSINKI = "Europe/Helsinki";

    public static final Pattern OID_PATTERN = Pattern.compile("[0-2](\\.(0|[1-9][0-9]*))*");

    public static final Pattern SSN_PATTERN = Pattern.compile("^[0-3][0-9](([0][1-9])|([1][0-2]))[0-9][0-9][YXWVUABCDEF+-][0-9][0-9][0-9][0-9A-Y]$");

    public static final String ULKOINEN_VIRHEKOODISTO_NAMESPACE_URI = "http://virhekoodisto.webservices.koodistopalvelu.kanta.fi";
    public static final String ULKOINEN_VIRHEKOODISTO_LOCALPART = "Virhekoodisto";
    public static final String KOODISTOPALVELU_OK_CODE = "400000";

    public static final String BASICCODE_LANGUAGE = "fi";
    public static final String SHP_CODE_CODESYSTEM = "1.2.246.537.6.22.2003";
    public static final String ATTRIBUTE_ORG = "TerveydenhuollonOrganisaationOID";
    public static final String ATTRIBUTE_SHP = "Sairaanhoitopiiri";
    public static final String FIRSTVERSION = "1";
    public static final String IS_TRUE = "1";

    public static final String FILEFORMAT_CODESYSTEM = "1.2.246.537.5.40179.2008";
    public static final String FILEFORMAT_CDAR2 = FILEFORMAT_CODESYSTEM.concat(PTAYhteisetConstants.CV_SEPARATOR).concat("1");
    public static final String DOCUMENTIN_TYYPPI_CODESYSTEM = "1.2.246.537.5.40153.2008";
    public static final String TOS_CODESYSTEM = "1.2.246.537.5.40170.2008";
    public static final String ASIAKIRJAN_VALMISTUMISEN_TILA_CODESYSTEM = "1.2.246.537.5.40154.2008";
    public static final String REKISTERINPITAJAN_TYYPPI_CODESYSTEM = "1.2.246.537.5.40172.2008";
    public static final String SAILYTYSAIKALUOKAT_CODESYSTEM = "1.2.246.537.5.40158.2008";

    public static final String REKISTERINPITAJA_KELA = "1.2.246.10.2462460.19.1";
    public static final String REKISTERI_CODESYSTEM = "1.2.246.537.5.40150.2009";
    public static final String REKISTERINPITAJA_REKISTERI_CODESYSTEM = "1.2.246.537.6.40174.2008";
    public static final String TERVEYDENHUOLLON_ITSENAISET_AMMATINHARJOITTAJAT = "1.2.246.537.6.203.2014";
    public static final String THL_SOTE_ORGANISAATIOREKISTERI = "1.2.246.537.6.202.2008";
    public static final String NAKYMATUNNUS_CODESYSTEM = "1.2.246.537.6.12.2002";
    public static final String PATIENTID_OFFICIAL_CODEBASE = "1.2.246.21";

    public static final String TEMP_PATIENTID_OFFICIAL_CODEBASE = "1.2.246.22";
    public static final String REGISTER_SPECIFIER_CODESYSTEM = "1.2.246.10";

    public static final String OTHER_REGISTER_SPECIFIER_CODESYSTEM = "1.2.246.537.30";
    public static final int PATIENTID_OFFICIAL_LENGTH = 22;
    public static final int PATIENTID_EXTENSION_OFFICIAL_LENGTH = 11;

    public static final String AUTHENTICATION_METHOD_CODESYSTEM = "1.2.246.537.5.40128.2006";

    public static final String SPECIAL_REASON_CODESYSTEM = "1.2.246.537.6.240.2012";

    public static final String USAGE_SITUATION_CODESYSTEM = "1.2.246.537.6.882.201501";

    public static final String TYOTERVEYS_REGISTER_SPECIFIER = "4";

    public static final String[] CHECKTABLE = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "H", "J", "K", "L", "M", "N", "P", "R", "S", "T", "U", "V", "W", "X", "Y" };

    public static final String SEPARATOR = ".";
    public static final String CV_SEPARATOR = "!";
    public static final String FORMATTING_ANCHOR = " {}";
    public static final String MV_SEPARATOR = "*|*";
    public static final String SPACE_SEPARATOR = " ";
    public static final String UNDERSCORE_SEPARATOR = "_";
    public static final String AUTHORID_SEPARATOR = "@";
    public static final String COMMA_SEPARATOR = ",";
    public static final String PIPE_SEPARATOR = "|";

    public static final String HL7_TIMESTAMP_ORACLE_TO_DATE_FORMAT = "YYYYMMDDHH24:MI:SS";
    public static final String ORACLE_DATE_LONG_FORMAT = "MM/dd/yyyy HH24:MI:SS";
    public static final String ORACLE_DATE_LONG_JAVA_FORMAT = "MM/dd/yyyy HH:mm:ss";
    public static final String BIRTHDATE_FORMAT = "yyyyMMdd";
    private static final Timestamp NULL_TIMESTAMP = Timestamp.valueOf("0001-01-01 02:00:00.0");
    public static final String DATE_TIME_FORMAT_FI = "dd.MM.yyyy HH:mm:ss";
    public static final String LOG_SERVICE_DATEFORMAT = "uuuu-MM-dd'T'HH:mm:ss.SSS'T'ZD";

    public static final String CODESYSTEM_KEY = "s";

    public static final String CODE_KEY = "c";

    public static final String VALUE_KEY = "v";

    public static final String HATAHAKU_SPECIAL_REASON_VALUE = "13";

    public static final String[] VALID_REGISTER_SPECIFIER_CODESYSTEMS = ArrayUtils.toArray(OTHER_REGISTER_SPECIFIER_CODESYSTEM, PATIENTID_OFFICIAL_CODEBASE, REGISTER_SPECIFIER_CODESYSTEM);

    /**
     * Palauttaa Documentumin asettaman nulldaten arvon.
     * 
     * @return Documentumin asettama nulldaten arvo
     */
    public static Timestamp getNullTimestamp() {
	return NULL_TIMESTAMP;
    }


    private PTAYhteisetConstants() {
	// yksityinen konstruktori
    }
}
