package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;

/**
 * Virallisen hetun validaattori. Tarkastaa että merkkijonon pituus vastaa virallisen hetun pituutta(22 merkkiä) ja että
 * merkkijono alkaa virallisen hetun rootilla "1.2.246.21".
 */
@Documented
@Constraint(validatedBy = VirallinenHetuValidator.class)
@Target({ ElementType.METHOD, ElementType.FIELD })
@Retention(RUNTIME)
public @interface VirallinenHetuConstraint {
    String message() default "Potilaan hetu virheellinen";


    Class<?>[] groups() default {};


    Class<? extends Payload>[] payload() default {};
}
