package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.xml;

/**
 * Luokka hakusanoman XPath-lausekkeisiin liittyville vakioille
 */
public class XPathExpressionHakuConstants {

    public static final String V3_PREFIX = "/v3:";
    public static final String EXPRESSION_INTERAKTIO_TUNNUS = "local-name(/*)";
    public static final String EXPRESSION_SANOMA_ID = "/v3:id/@root";
    public static final String EXPRESSION_REKISTERINPITAJA = "/v3:controlActProcess/v3:overseer/v3:assignedPerson/v3:representedOrganization/v3:id";
    public static final String EXPRESSION_REKISTERITUNNUS = "/v3:controlActProcess/v3:overseer/v3:assignedPerson/v3:representedOrganization/v3:code";
    public static final String EXPRESSION_REKISTERITARKENNE = "/v3:controlActProcess/v3:overseer/v3:assignedPerson/v3:representedOrganization/v3:asOrganizationPartOf/v3:id";
    public static final String EXPRESSION_ERITYINEN_SYY = "/v3:controlActProcess/v3:reasonOf/v3:detectedIssueEvent/v3:mitigatedBy/v3:detectedIssueManagement/v3:code[@codeSystem='1.2.246.537.6.240.2012']";
    public static final String EXPRESSION_METATIETOKOHDISTUS = "/v3:controlActProcess/v3:reasonCode[@codeSystem='1.2.246.537.5.40159.2008']";
    public static final String EXPRESSION_PALAUTETTAVIEN_TIETOJEN_KATTAVUUS = "/v3:controlActProcess/v3:reasonCode[@codeSystem='1.2.246.537.5.40160.2008']";
    public static final String EXPRESSION_YKSITYISTEN_LIITTYMISMALLI = "/v3:controlActProcess/v3:reasonCode[@codeSystem='1.2.246.537.5.40200.2014']";
    public static final String EXPRESSION_YHTEISLIITTYJA_PALVELUNANTAJA = "/v3:controlActProcess/v3:authorOrPerformer/v3:assignedPerson/v3:representedOrganization/v3:asOrganizationPartOf/v3:wholeOrganization/v3:id";
    public static final String EXPRESSION_PALVELUNANTAJA = "/v3:controlActProcess/v3:authorOrPerformer/v3:assignedPerson/v3:representedOrganization/v3:id";
    public static final String EXPRESSION_PALVELUNANTAJAN_NIMI = "/v3:controlActProcess/v3:authorOrPerformer/v3:assignedPerson/v3:representedOrganization/v3:name";
    public static final String EXPRESSION_SANOMA_CREATION_TIME = "/v3:creationTime/@value";
    public static final String EXPRESSION_PALAUTUKSEN_TIEDOSTOMUOTO = "/v3:controlActProcess/v3:reasonCode[@codeSystem='1.2.246.537.5.40179.2008']";

    public static final String EXPRESSION_QUERYPARAM_TABLE_OF_CONTENTS = "/v3:controlActProcess/v3:queryByParameter/v3:tableOfContents/v3:value";
    public static final String EXPRESSION_QUERYPARAM_PROCEDURECODE = "/v3:controlActProcess/v3:queryByParameter/v3:procedureCode/v3:value";
    public static final String EXPRESSION_QUERYPARAM_DIAGNOSISCODE = "/v3:controlActProcess/v3:queryByParameter/v3:diagnosisCode/v3:value";
    public static final String EXPRESSION_QUERYPARAM_REPRESENTED_ORGANIZATION_ID_NO_TEMPLATEID = "/v3:controlActProcess/v3:queryByParameter/v3:representedOrganization.id[not(v3:templateId)]/v3:value";
    public static final String EXPRESSION_QUERYPARAM_REPRESENTED_ORGANIZATION_ID_JARJESTAJA = "/v3:controlActProcess/v3:queryByParameter/v3:representedOrganization.id[./v3:templateId[@root='1.2.246.537.6.12.999.33.5']]/v3:value";
    public static final String EXPRESSION_QUERYPARAM_REPRESENTED_ORGANIZATION_ID_TUOTTAJA = "/v3:controlActProcess/v3:queryByParameter/v3:representedOrganization.id[./v3:templateId[@root='1.2.246.537.6.12.999.33.6']]/v3:value";
    public static final String EXPRESSION_QUERYPARAM_REPRESENTED_ORGANIZATION_ID_NULLFLAVOR = "/v3:controlActProcess/v3:queryByParameter/v3:representedOrganization.id/v3:value/@nullFlavor";
    public static final String EXPRESSION_QUERYPARAM_REPRESENTED_ORGANIZATION_PALVELUYKSIKKO = "/v3:controlActProcess/v3:queryByParameter/v3:representedOrganization.id/v3:templateId[@root = '1.2.246.537.6.12.999.33.7']/../v3:value";

    public static final String EXPRESSION_QUERYPARAM_PATIENT_REGISTRY_SPECIFIER = "/v3:controlActProcess/v3:queryByParameter/v3:patientRegistrySpecifier/v3:value";
    public static final String EXPRESSION_QUERYPARAM_CUSTODIANTYPE_CODE = "/v3:controlActProcess/v3:queryByParameter/v3:custodianTypeCode/v3:value";
    public static final String EXPRESSION_QUERYPARAM_CLINICALDOCUMENT_CODE = "/v3:controlActProcess/v3:queryByParameter/v3:clinicalDocument.code/v3:value";
    public static final String EXPRESSION_QUERYPARAM_ENCOMPASSINGENCOUNTER_ID = "/v3:controlActProcess/v3:queryByParameter/v3:encompassingEncounter.id/v3:value";
    public static final String EXPRESSION_QUERYPARAM_CLINICALDOCUMENT_ID = "/v3:controlActProcess/v3:queryByParameter/v3:clinicalDocument.id/v3:value";
    public static final String EXPRESSION_QUERYPARAM_SETID = "/v3:controlActProcess/v3:queryByParameter/v3:setId/v3:value";
    public static final String EXPRESSION_QUERYPARAM_QUERYID = "/v3:controlActProcess/v3:queryByParameter/v3:queryId";
    public static final String EXPRESSION_QUERYPARAM_PATIENT_ID = "/v3:controlActProcess/v3:queryByParameter/v3:patient.id/v3:value";
    public static final String EXPRESSION_QUERYPARAM_ACTIVE_ENCOMPASSING_ENCOUNTER_ID = "/v3:controlActProcess/v3:queryByParameter/v3:activeEncompassingEncounterId/v3:value";
    public static final String EXPRESSION_QUERYPARAM_INITIALQUANTITY = "/v3:controlActProcess/v3:queryByParameter/v3:initialQuantity/@value";
    public static final String EXPRESSION_QUERYPARAM_ENCOMPASSINGENCOUNTER_EFFECTIVE_TIME_HIGH = "/v3:controlActProcess/v3:queryByParameter/v3:encompassingEncounter.effectiveTime/v3:value/v3:high/@value";
    public static final String EXPRESSION_QUERYPARAM_ENCOMPASSINGENCOUNTER_EFFECTIVE_TIME_HIGH_INCLUSIVE = "/v3:controlActProcess/v3:queryByParameter/v3:encompassingEncounter.effectiveTime/v3:value/v3:high/@inclusive";
    public static final String EXPRESSION_QUERYPARAM_ENCOMPASSINGENCOUNTER_EFFECTIVE_TIME_LOW_INCLUSIVE = "/v3:controlActProcess/v3:queryByParameter/v3:encompassingEncounter.effectiveTime/v3:value/v3:low/@inclusive";
    public static final String EXPRESSION_QUERYPARAM_ENCOMPASSINGENCOUNTER_EFFECTIVE_TIME_LOW = "/v3:controlActProcess/v3:queryByParameter/v3:encompassingEncounter.effectiveTime/v3:value/v3:low/@value";
    public static final String EXPRESSION_QUERYPARAM_EFFECTIVE_TIME_HIGH_INCLUSIVE = "/v3:controlActProcess/v3:queryByParameter/v3:clinicalDocument.effectiveTime/v3:value/v3:high/@inclusive";
    public static final String EXPRESSION_QUERYPARAM_EFFECTIVE_TIME_HIGH = "/v3:controlActProcess/v3:queryByParameter/v3:clinicalDocument.effectiveTime/v3:value/v3:high/@value";
    public static final String EXPRESSION_QUERYPARAM_EFFECTIVE_TIME_LOW_INCLUSIVE = "/v3:controlActProcess/v3:queryByParameter/v3:clinicalDocument.effectiveTime/v3:value/v3:low/@inclusive";
    public static final String EXPRESSION_QUERYPARAM_EFFECTIVE_TIME_LOW = "/v3:controlActProcess/v3:queryByParameter/v3:clinicalDocument.effectiveTime/v3:value/v3:low/@value";
    public static final String EXPRESSION_QUERYPARAM_INCLUDE_OWNDOCUMENTS_IN_RESULT = "/v3:controlActProcess/v3:queryByParameter/v3:includeOwnDocumentsInResult/@value";
    public static final String EXPRESSION_QUERYPARAM_LANGUAGECODE = "/v3:controlActProcess/v3:queryByParameter/v3:languageCode/v3:value/@code";
    public static final String EXPRESSION_QUERYPARAM_ASSIGNED_AUTHOR_ID = "/v3:controlActProcess/v3:queryByParameter/v3:assignedAuthor.id/v3:value";

    /**
     * xpath-polku lomakkeen value-kenttään.
     */
    public static final String LOMAKE_VALUE = "/v3:ClinicalDocument/v3:component/v3:structuredBody/v3:component/v3:section/v3:component/v3:section/v3:component/v3:section/v3:code[@code='%s']/../v3:entry/v3:observation/v3:value/@value";
    /**
     * xpath-polku lomakkeen ST-tietotyypin arvoon.
     */
    public static final String LOMAKE_ST_VALUE = "/v3:ClinicalDocument/v3:component/v3:structuredBody/v3:component/v3:section/v3:component/v3:section/v3:component/v3:section/v3:code[@code='%s']/../v3:text";
    /**
     * xpath-polku lomakekoodiin.
     */
    public static final String LOMAKE_KOODI = "/v3:ClinicalDocument/v3:component/v3:structuredBody/v3:component/v3:section/v3:code/@code";

    /**
     * xpath-polku merkinnän templateId:hen..
     */
    public static final String TEMPLATE_ID_XPATH = "/v3:ClinicalDocument/v3:component/v3:structuredBody/v3:component/v3:section/v3:templateId";

    public static final String EXPRESSION_STRUCTURED_BODY = "/v3:ClinicalDocument/v3:component/v3:structuredBody";
    public static final String EXPRESSION_NON_XML_BODY_SIJAINTI = "/v3:ClinicalDocument/v3:component";

    private XPathExpressionHakuConstants() {
        // yksityinen konstruktori
    }
}
