package fi.kela.kanta.ptayhteiset.repositorio.metatiedot;

import java.util.HashMap;
import java.util.Map;

import fi.kela.kanta.ptayhteiset.repositorio.transaktio.TallennusTulos;
import fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit.IIValue;

/**
 *  Tallennettavan asiakirjan tiedot 
 *  Pääasiassa käytetään asiakirjan tallennuksessa, jossa asiakirjan ja sanoman xml-käsittelyn seurauksena 
 *  saadaan AsiakirjaEntity objekti, joka sisältää asiakirjalta poimitut metatiedot ja asiakirjan 
 *  sisällön.
 */
public class AsiakirjaEntity {

    private String asiakirjaId;
    private String relatedDocumentRplcId;
    private String relatedDocumentRplcSetId;
    private String relatedDocumentApndId;
    private String relatedDocumentApndSetId;
    private IIValue patientId;
    private String xmlString;
    private String pdfString;
    private Map<String, Metadata> metadataMap;
    private Map<String, Metadata> relatedMetadataMap;
    private String targetRepository;
    private String sourceRepository;
    private String objectType;
    
    public String getObjectType() {
        return objectType;
    }


    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }


    private String tallennusTilanne;
    private TallennusTulos tallennusTulos;

    /**
     * Palauttaa asiakirjan yksilöintitunnuksen.
     * 
     * @return asiakirjan yksilöintitunnuksen
     */
    public String getAsiakirjaId() {
        return asiakirjaId;
    }


    /**
     * Asettaa asiakirjan yksilöintitunnuksen.
     * 
     * @param id asiakirjan yksilöintitunnus
     */
    public void setAsiakirjaId(String id) {
        this.asiakirjaId = id;
    }


    /**
     * Palauttaa korvattavan asiakirjan yksilöintitunnuksen.
     * 
     * @return korvattavan asiakirjan yksilöintitunnus
     */
    public String getRelatedDocumentRplcId() {
        return relatedDocumentRplcId;
    }


    /**
     * Korvattavan asiakirjan yksilöintitunnuksen asetus.
     * 
     * @param relatedDocumentRplcId korvattavan asiakirjan yksilöintitunnus
     */
    public void setRelatedDocumentRplcId(String relatedDocumentRplcId) {
        this.relatedDocumentRplcId = relatedDocumentRplcId;
    }


    /**
     * Palauttaa alkuperäisen asiakirjan yksilöintitunnuksen.
     * 
     * @return alkuperäisen asiakirjan yksilöintitunnus
     */
    public String getRelatedDocumentRplcSetId() {
        return relatedDocumentRplcSetId;
    }


    /**
     * Asiakirjan alkuperäisen asiakirjan yksilöintitunnuksen asetus.
     * 
     * @param relatedDocumentRplcSetId alkuperäisen asiakirjan yksilöintitunnus
     */
    public void setRelatedDocumentRplcSetId(String relatedDocumentRplcSetId) {
        this.relatedDocumentRplcSetId = relatedDocumentRplcSetId;
    }


    /**
     * Palauttaa asiakirjan pohja-asiakirjan yksilöintitunnuksen.
     * 
     * @return asiakirjan pohja-asiakirjan yksilöintitunnus
     */
    public String getRelatedDocumentApndId() {
        return relatedDocumentApndId;
    }


    /**
     * Asiakirjan pohja-asiakirjan yksilöintitunnuksen asetus.
     * 
     * @param relatedDocumentApndId asiakirjan pohja-asiakirjan yksilöintitunnus
     */
    public void setRelatedDocumentApndId(String relatedDocumentApndId) {
        this.relatedDocumentApndId = relatedDocumentApndId;
    }


    /**
     * Palauttaa pohja-asiakirjan alkuperäisen asiakirjan yksilöintitunnuksen.
     * 
     * @return pohja-asiakirjan alkuperäisen asiakirjan yksilöintitunnus
     */
    public String getRelatedDocumentApndSetId() {
        return relatedDocumentApndSetId;
    }


    /**
     * Asiakirjan pohja-asiakirjan alkuperäisen asiakirjan yksilöintitunnuksen asetus.
     * 
     * @param relatedDocumentApndSetId pohja-asiakirjan alkuperäisen asiakirjan yksilöintitunnus
     */
    public void setRelatedDocumentApndSetId(String relatedDocumentApndSetId) {
        this.relatedDocumentApndSetId = relatedDocumentApndSetId;
    }


    /**
     * Palauttaa potilaan hetun.
     * 
     * @return potilaan hetu
     */
    public IIValue getPatientId() {
        return patientId;
    }


    /**
     * Potilaan hetun asetus.
     * 
     * @param patientId potilaan hetu
     */
    public void setPatientId(IIValue patientId) {
        this.patientId = patientId;
    }


    /**
     * Palauttaa asiakirja xml:n merkkijonona.
     * 
     * @return asiakirja xml:n merkkijonona
     */
    public String getXmlString() {
        return xmlString;
    }


    /**
     * Asiakirja xml:n asetus.
     * 
     * @param xmlString asiakirja xml merkkijonona
     */
    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }


    /**
     * Palauttaa asiakirja pdf sisällön merkkijonona.
     * 
     * @return asiakirjan pdf sisältö merkkijonona
     */
    public String getPdfString() {
        return pdfString;
    }


    /**
     * Asiakirjan pdf sisällön asetus.
     * 
     * @param pdfString asiakirjan pdf sisältö merkkijonona
     */
    public void setPdfString(String pdfString) {
        this.pdfString = pdfString;
    }


    /**
     * Palauttaa asiakirjan tallennettavat metatiedot.
     * 
     * @return mappi asiakirjan tallennettavista metatiedoista
     */
    public Map<String, Metadata> getMetadataMap() {

        if (metadataMap == null) {
            metadataMap = new HashMap<>();
        }

        return metadataMap;
    }


    /**
     * Asiakirjan tallennettavien metatietojen asetus.
     * 
     * @param metadataMap tallennettavat metatiedot
     */
    public void setMetadataMap(Map<String, Metadata> metadataMap) {
        this.metadataMap = metadataMap;
    }


    /**
     * Palauttaa korvattavan asiakirjan metatiedot.
     * 
     * @return mappi korvattavan asiakirjan metatiedoista
     */
    public Map<String, Metadata> getRelatedMetadataMap() {

        if (relatedMetadataMap == null) {
            relatedMetadataMap = new HashMap<>();
        }

        return relatedMetadataMap;
    }


    /**
     * Korvattavan asiakirjan metatietojen asetus.
     * 
     * @param relatedDocumentMetadataMap korvattavan asiakirjan metatiedot
     */
    public void setRelatedMetadataMap(Map<String, Metadata> relatedMetadataMap) {
        this.relatedMetadataMap = relatedMetadataMap;
    }


    /**
     * Palauttaa asiakirjan tallennuskohteen.
     * 
     * @return asiakirjan tallennuskohde
     */
    public String getTargetRepository() {
        return targetRepository;
    }


    /**
     * Asiakirjan tallennuskohteen asetus.
     * 
     * @param targetRepository asiakirjan tallennuskohde
     */
    public void setTargetRepository(String targetRepository) {
        this.targetRepository = targetRepository;
    }


    /**
     * Palauttaa asiakirjan edellisen version tallennuskohteen.
     * 
     * @return asiakirjan edellisen version tallennuskohde
     */
    public String getSourceRepository() {
        return sourceRepository;
    }


    /**
     * Asiakirjan edellisen version tallennuskohteen asetus.
     * 
     * @param sourceRepository asiakirjan edellisen version tallennuskohde
     */
    public void setSourceRepository(String sourceRepository) {
        this.sourceRepository = sourceRepository;
    }







    /**
     * Palauttaa tallennustilanne tiedon.
     * 
     * @return tallennusTilanne
     */
    public String getTallennusTilanne() {
        return tallennusTilanne;
    }


    /**
     * Tallennustilanne tiedon asetus.
     * 
     * @param tallennusTilanne tallennustilanne tieto
     */
    public void setTallennusTilanne(String tallennusTilanne) {
        this.tallennusTilanne = tallennusTilanne;
    }


    /**
     * Palauttaa tallennustransaktiossa tehtyjen operaatioiden tiedot.
     * 
     * @return tallennustulos
     */
    public TallennusTulos getTallennusTulos() {
        return tallennusTulos;
    }


    /**
     * Tallennustuloksen asetus.
     * 
     * @param tallennusTulos tallennustransaktiossa tehtyjen operaatioiden tiedot
     */
    public void setTallennusTulos(TallennusTulos tallennusTulos) {
        this.tallennusTulos = tallennusTulos;
    }

}