package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

import java.util.HashMap;
import java.util.Map;

import fi.kela.kanta.ptayhteiset.tietomalli.vakiot.PTAYhteisetConstants;

/**
 * Enumeraatio näkymäkoodiston 1.2.246.537.6.12.2002 käsiteltäville arvoille arvoille.
 */
public enum Nakymakoodit {

    // @formatter:off

    ELINLUOVUTUS("152"),
    ENSIHOITOKERTOMUS("348"),
    HAMMAS_SUU_LEUKA("58"),
    HAMMASSTATUS("360"),
    HAUTAUS_ALLE28("206"),
    HAUTAUS_YLI28("205"),
    HOITOONMAARAAMISPAATOS("114"),
    HOITOPALAUTE("125"),
    HOITOTAHTO("165"),
    INFORMOINTI("332"),
    KANTA_INFORMOINTI("339"),
    KIELTO ("331"),
    KIELTO_LAAJA("340"),
    KIELTO_YHTEENVETO("338"),
    KIELTO_YHTEENVETO_HUOLTAJALLE("337"),
    KUOLILM28("204"),
    KUOLINILMOITUS("203"),
    KUOLINTODISTUS_28VRK("154"),
    KUOLINTODISTUS_ALLE_28VRK("202"),
    KUOLINTODISTUS28_KELA("207"),
    LAAKARINLAUSUNTO_AJOKYKY("151"),
    LAAKARINLAUSUNTO_B("372"),
    LAAKARINLAUSUNTO_ERITYIS_AITIYSVAPAA("375"),
    LAAKARINLAUSUNTO_IKA_AJOTERVEYS("913"),
    LAAKARINLAUSUNTO_NAKOKYVYSTA("916"),
    LAAKARINLAUSUNTO_TERVEYDENTILA("149"),
    LAAKARINLAUSUNTO_VAMMAISEN_AJOLUPA("915"),
    LAAKARINTODISTUS("373"),
    LAAKARINTODISTUS_A("141"),
    LAAKARINTODISTUS_D("145"),
    LAAKARINTODISTUS_E("146"),
    LAAKEMAARAYKSEN_KIELTO("370"),
    LABORATORIO("103"),
    LAHETE("124"),
    LUOVUTUSILMOITUS("322"),
    MATKAKORVAUS_TODISTUS("148"),
    OPTOMETRIA("380"),
    OSTOPALVELUN_VALTUUTUS("362"),
    PS_SUOSTUMUS("504"),
    RADIOLOGIA("102"),
    RAJAT_YLITTAVA_RESEPTI_INFO_SUOSTUMUS("346"),
    RISKITIEDOT("175"),
    ROKOTETODISTUS_COVID("390"),
    ROKOTUKSET("201"),
    SAIRASTUSTODISTUS_COVID("392"),
    SUOSTUMUS("330"),
    SYNTYMATODISTUS("153"),
    TARKKAILULAHETE_M1("112"),
    TARKKAILULAUSUNTO_M2("113"),
    TERVEYS_HOITOSUUNNITELMA("345"),
    TESTITULOSTODISTUS_COVID("391"),
    TODISTUS_RASKAUDESTA("364"),
    YHTEYDENOTTO_KIELTO("503"),
    LAAKARIN_ILMOITUS_AJOTERVEYDEN_MUUTOKSESTA_POLIISILLE("914"),
    HOIDONTARPEEN_ARVIO("924"),
    HOITAJANTODISTUS("1001"),
    LAAKARIN_ILMOITUS_AMMATTITAUDISTA("156");

    // @formatter:on

    private static final Map<String, Nakymakoodit> lookup = new HashMap<>();

    private static final Map<String, String> lookupCV = new HashMap<>();

    static {
        for (Nakymakoodit asiakirjaTyyppi : Nakymakoodit.values()) {
            lookup.put(asiakirjaTyyppi.getValue(), asiakirjaTyyppi);
        }

        for (Nakymakoodit asiakirjaTyyppi : Nakymakoodit.values()) {
            lookupCV.put(asiakirjaTyyppi.getValue(), PTAYhteisetConstants.NAKYMATUNNUS_CODESYSTEM
                    .concat(PTAYhteisetConstants.CV_SEPARATOR.concat(asiakirjaTyyppi.getValue())));
        }
    }
    /**
     * Palauttaa enumeraation annetun arvon perusteella.
     *
     * @param value arvo
     * @return enumeraatio
     */
    public static Nakymakoodit get(String value) {
        return lookup.get(value);
    }

    /**
     * Palauttaa enumeraation annetun arvon perusteella CV-tyypin esitysmuodossa esim. 1.2.246.537.6.12.2002!152.
     *
     * @param value arvo
     * @return näkymäkoodi CV-tyypin esitysmuodossa
     */
    public static String getCV(String value) {
        return lookupCV.get(value);
    }

    private final String value;


    private Nakymakoodit(String value) {
        this.value = value;
    }


    /**
     * Palauttaa näkymäkoodin arvon.
     *
     * @return näkymäkoodin arvo
     */
    public String getValue() {
        return value;
    }
}
