package fi.kela.kanta.ptayhteiset.tietomalli.poikkeukset;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * REST-palvelujen kautta virhetilanteessa palautettavat virhetiedot
 */
public class ErrorInfo {
    private String timestamp;
    private String errorCode;
    private String errorMessage;
    private String description;
    private String path;
    private int status;


    /**
     * ErrorInfo luokan oletuskonstruktori
     */
    public ErrorInfo() {
	this.timestamp = getCurrentDate();
    }


    /**
     * ErrorInfo luokan konstruktori
     *
     * @param errorCode virhekoodi
     * @param errorMessage virheviesti
     */
    public ErrorInfo(String errorCode, String errorMessage) {
	this.errorCode = errorCode;
	this.errorMessage = errorMessage;
	this.timestamp = getCurrentDate();
    }


    /**
     * ErrorInfo luokan konstruktori
     *
     * @param errorCode virhekoodi
     * @param errorMessage virheviesti
     * @param description virheen lisäselite
     */
    public ErrorInfo(String errorCode, String errorMessage, String description) {
	this.errorCode = errorCode;
	this.errorMessage = errorMessage;
	this.description = description;
	this.timestamp = getCurrentDate();
    }


    /**
     * Palauttaa virhekoodin
     *
     * @return virhekoodi
     */
    public String getErrorCode() {
	return errorCode;
    }


    /**
     * Virhekoodin asetus
     *
     * @param errorCode virhekoodi
     */
    public void setErrorCode(final String errorCode) {
	this.errorCode = errorCode;
    }


    /**
     * Palauttaa virheviestin
     *
     * @return virheviesti
     */
    public String getErrorMessage() {
	return errorMessage;
    }


    /**
     * Virheviestin asetus
     *
     * @param errorMessage virheviesti
     */
    public void setErrorMessage(final String errorMessage) {
	this.errorMessage = errorMessage;
    }


    /**
     * Palauttaa virheen lisäselitteen
     *
     * @return virheen lisäselitys
     */
    public String getDescription() {
	return description;
    }


    /**
     * Virheen lisäselitteen asetus
     *
     * @param description virheen lisäselitys
     */
    public void setDescription(final String description) {
	this.description = description;
    }


    /**
     * Palauttaa instanssin luontiajan
     *
     * @return luontiaika
     */
    public String getTimestamp() {
	return timestamp;
    }


    /**
     * Palauttaa palvelun osoitteen, jota kutsuttiin virheen sattuessa
     *
     * @return palvelun osoite
     */
    public String getPath() {
	return path;
    }


    /**
     * Palvelun osoitteen asetus
     *
     * @param path palvelun osoite
     */
    public void setPath(String path) {
	String newPath = path;
	if (newPath != null) {
	    int index = newPath.indexOf('=');
	    if (index > 0) {
		newPath = newPath.substring(index + 1);
	    }
	}
	this.path = newPath;
    }


    /**
     * Palauttaa http-virheen statuskoodin
     *
     * @return statuskoodi
     */
    public int getStatus() {
	return status;
    }


    /**
     * Http-virheen asetus
     *
     * @param status virhekoodi
     */
    public void setStatus(int status) {
	this.status = status;
    }


    @Override
    public String toString() {
	return errorCode + ", " + errorMessage;
    }


    /**
     * Palauttaa nykyhetken
     *
     * @return
     */
    private static String getCurrentDate() {
	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
	return sdf.format(new Date());
    }
}