package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;

/**
 * Tarkastaa että hakuparametri-hetulle on validi II-tyyppi ja tarkastaa virallisen hetun muodon.
 * Mahdollisuus pakottaa virallisen hetun tarkastukset kaikille mustBeOfficial-parametrilla.
 * 
 * Hyväksyy null-arvon, joten kentän pakollisuuteen käytä lisäannotaatioita.
 */
@Constraint(validatedBy = HetuValidator.class)
@Retention(RetentionPolicy.RUNTIME)
public @interface HetuConstraint {

    String message() default "Ongelma henkilötunnuksen validoinnissa";

    boolean mustBeOfficialHetu() default false;

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
    
}
