package fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit;

import java.beans.Transient;
import java.io.Serializable;

import fi.kela.kanta.ptayhteiset.tietomalli.vakiot.PTAYhteisetConstants;

/**
 * Koodi + koodisto -tyyppisten tietueiden käyttöön.
 */
public class CVValue implements Serializable {

    private static final long serialVersionUID = 8507368233752509107L;

    private String codeSystem;
    private String code;


    /**
     * Oletuskonstruktori.
     */
    public CVValue() {
	super();
    }


    /**
     * Konstruktori.
     * 
     * @param codeSystem koodisto
     * @param code koodi
     */
    public CVValue(String codeSystem, String code) {
	super();
	this.codeSystem = codeSystem;
	this.code = code;
    }


    /**
     * Palauttaa koodiston arvon.
     * 
     * @return koodiston arvo
     */
    public String getCodeSystem() {
	return codeSystem;
    }


    /**
     * Koodiston arvon asetus.
     * 
     * @param codeSystem koodisto
     */
    public void setCodeSystem(String codeSystem) {
	this.codeSystem = codeSystem;
    }


    /**
     * Palauttaa koodin arvon.
     * 
     * @return koodin arvo
     */
    public String getCode() {
	return code;
    }


    /**
     * Koodin arvon asetus.
     * 
     * @param code koodin arvo
     */
    public void setCode(String code) {
	this.code = code;
    }


    /**
     * Palauttaa objektin arvon merkkijonona yhdistämällä koodiston arvon ja koodin CV-erotinmerkillä (koodisto!koodi).
     * 
     * @return objektin arvon merkkijonona
     */
    @Transient
    public String getCVValueWithSeparator() {
	return codeSystem.concat(PTAYhteisetConstants.CV_SEPARATOR.concat(code));
    }


    @Override
    public String toString() {
	return "CVValue [codeSystem=" + codeSystem + ", code=" + code + "]";
    }


    @Override
    public int hashCode() {
	final int prime = 31;
	int result = 1;
	result = prime * result + ((code == null) ? 0 : code.hashCode());
	result = prime * result + ((codeSystem == null) ? 0 : codeSystem.hashCode());
	return result;
    }


    @Override
    public boolean equals(Object obj) {
	if (this == obj)
	    return true;
	if (obj == null)
	    return false;
	if (getClass() != obj.getClass())
	    return false;
	CVValue other = (CVValue) obj;
	if (code == null) {
	    if (other.code != null) {
		return false;
	    }
	} else if (!code.equals(other.code))
	    return false;
	if (codeSystem == null) {
	    if (other.codeSystem != null) {
		return false;
	    }
	} else if (!codeSystem.equals(other.codeSystem))
	    return false;
	return true;
    }
}
