package fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit;

import java.util.ArrayList;
import java.util.List;

/**
 * PersonName, henkilön nimitiedot.
 */
public class PN {

    /**
     * Nimi-osion tyyppi enumeraatio
     */
    public enum NameType {
        GIVEN, FAMILY, PREFIX, SUFFIX, DELIMITER
    }

  

    /**
     * Lisää nimen osan koko
     * @param qualifier jos nimessä on qualifier, se tulee tähän..
     * @param content itse nimen sisältö, esimerkiksi: Cicero
     * @param orderno järjestysnumero, esim. etunimissä.. 
     * @param type Onko nimen osa etunimi, sukunimi, prefix suffix. PN.NameType enumeraatio
     */
    public void addName(String qualifier, String content, int orderno, PN.NameType type) {
        names.add(new NamePart(qualifier, content, orderno, type));
    }

    private List<NamePart> names = new ArrayList<>();

    /**
     * Palauttaa listan nimen osista joita muodostuu kokonimi, esim. Marcus Tullius Cicero
     * @return kokonimen muodostavat osiot.
     */
    public List<NamePart> getNames() {
        return names;
    }
    
    
 
}
