package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util;

import java.time.format.DateTimeFormatter;

import fi.kela.kanta.ptayhteiset.tietomalli.vakiot.PTAYhteisetConstants;

/**
 * Luokka päivämäärien käsittelyyn liittyville vakioille Kanta-palveluissa.
 */
public class PTArkistoDateTimeConstants {
    
    /**
     * HUOM. kaikissa patterneissa käytetään merkkiä 'u' kuvaamaan vuotta
     * https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/format/DateTimeFormatter.html
     * -----------------------------------------
     * Symbol	Meaning	Presentation	Examples
     * -----------------------------------------
     * u	year	        year	2004; 04
     * y	year-of-era	year	2004; 04
     * 
     * Käytetään 'u':ta jotta strict-validoinnissa ei tarvi antaa erikseen era arvoa
     * 
     */

    /**
     * yyyy pattern (vuosiluku) Esim. 2016
     */
    public static final String YYYY_DATE_PATTERN = "uuuu";
    public static final String DATE_YYYY_REGEXP = "^\\d{4}$";

    /**
     * yyyyMM pattern, (päivämäärä) Esim. 201610
     */
    public static final String YYYYMM_DATE_PATTERN = "uuuuMM";
    public static final String DATE_YYYYMM_REGEXP = "^\\d{6}$";

    /**
     * yyyyMMdd pattern, (päivämäärä) Esim. 20161021
     */
    public static final String YYYYMMDD_DATE_PATTERN = "uuuuMMdd";
    public static final String DATE_YYYYMMDD_REGEXP = "^\\d{8}$";
    
    /**
     * yyyy-MM-dd pattern, (päivämäärä) Esim. 2016-10-21
     */
    public static final String YYYY_MM_DD_DATE_PATTERN = "uuuu-MM-dd";
    public static final String DATE_YYYY_MM_DD_REGEXP = "^\\d{4}\\-\\d{2}\\-\\d{2}$";
    
    /**
     * yyyyMMddHHmmss pattern (päivämäärä ja aika tunnin tarkkuudella) Esim. 2016102113
     */
    public static final String YYYYMMDDHH_DATE_PATTERN = "uuuuMMddHH";
    public static final String DATE_YYYYMMDDHH_REGEXP = "^\\d{10}$";

    /**
     * yyyyMMddHHmmss pattern (päivämäärä ja aika minuutin tarkkuudella) Esim. 201610211319
     */
    public static final String YYYYMMDDHHMM_DATE_PATTERN = "uuuuMMddHHmm";
    public static final String DATE_YYYYMMDDHHMM_REGEXP = "^\\d{12}$";

    /**
     * yyyyMMddHHmmss pattern (päivämäärä ja aika sekunnin tarkkuudella) Esim. 20161021131917
     */
    public static final String YYYYMMDDHHMMSS_DATE_PATTERN = "uuuuMMddHHmmss";
    public static final String DATE_YYYYMMDDHHMMSS_REGEXP = "^\\d{14}$";

    /**
     * yyyyMMddHHmmssZZ pattern, (päivämäärä, aika sekunnin tarkkuudella ja aikavyöhykkeen ero koordinoituun yleisaikaan
     * (UTC)) Esim. 20161021131917+0300
     */
    public static final String YYYYMMDDHHMMSSZZ_DATE_PATTERN = "uuuuMMddHHmmssZZ";
    public static final String DATE_YYYYMMDDHHMMSSZZ_REGEXP = "^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})(.[0-9]+)?(Z|([+-](([0-9]{4})|([0-9]{2})|([0-9]{2}:[0-9]{2}))))$";

    /**
     * ISO 8601 pattern (päivämäärä, aika sekunnin tarkkuudella ja aikavyöhykkeen ero koordinoituun yleisaikaan (UTC))
     * Esim. 2016-10-21T13:19:17+03:00
     */
    public static final String ISO_8601_DATE_PATTERN = "uuuu-MM-dd'T'HH:mm:ssZ";
    public static final String ISO_8601_REGEXP = "^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})(.[0-9]+)?(Z|([+-](([0-9]{4})|([0-9]{2})|([0-9]{2}:[0-9]{2}))))$";

    public static final DateTimeFormatter ORACLE_DATE_LONG_JAVA_FORMATTER = DateTimeFormatter.ofPattern(PTAYhteisetConstants.ORACLE_DATE_LONG_JAVA_FORMAT);

    // uuuu-MM-dd'T'HH:mm:ss.S'T'ZD pattern, esim. 2022-09-14T14:35:39.775T+0300257
    public static final DateTimeFormatter LOG_SERVICE_DATEFORMAT_FORMATTER = DateTimeFormatter.ofPattern(PTAYhteisetConstants.LOG_SERVICE_DATEFORMAT);

    public static final String DATE_HOURS = "235959";


    /**
     * Yksityinen konstruktori
     */
    private PTArkistoDateTimeConstants() {
	// estetään instanssien luonti
    }
}
