package fi.kela.kanta.ptayhteiset.repositorio.metatiedot;

import java.util.ArrayList;
import java.util.List;

/**
 * Tallennettavan metatietokentän tiedot.
 */
public class Metadata {

    private int attributeType;
    private String attributeName;
    private String attributeValue;
    private List<String> attributeValues;
    private boolean isRepeating;
    private int attributeFieldLength;
    private OperationMode operationMode;


    /**
     * Metadata luokan konstruktori.
     * 
     * @param attributeType attribuutin tyyppi
     * @param attributeName attribuutin nimi
     * @param attributeValue attribuutin arvo
     * @param attributeValues attribuutin arvokokoelma
     * @param isRepeating onko attribuutti kokoelmatyyppinen
     * @param attributeFieldLength attribuutin kentän maksimipituus tietokannassa
     * @param operationMode metatiedon käsittelyä ohjaava operaatiotieto
     */
    public Metadata(int attributeType, String attributeName, String attributeValue, List<String> attributeValues, boolean isRepeating, int attributeFieldLength, OperationMode operationMode) {
	this.attributeType = attributeType;
	this.attributeName = attributeName;
	this.attributeValue = attributeValue;
	this.attributeValues = attributeValues;
	this.isRepeating = isRepeating;
	this.attributeFieldLength = attributeFieldLength;
	this.operationMode = operationMode;
    }


    /**
     * Metadata luokan konstruktori.
     * 
     * @param attributeType attribuutin tyyppi
     * @param attributeName attribuutin nimi
     * @param attributeValue attribuutin arvo
     * @param attributeFieldLength attribuutin kentän maksimipituus tietokannassa
     * @param operationMode metatiedon käsittelyä ohjaava operaatiotieto
     */
    public Metadata(int attributeType, String attributeName, String attributeValue, int attributeFieldLength, OperationMode operationMode) {
	this(attributeType, attributeName, attributeValue, null, false, 0, operationMode);
    }


    /**
     * Metadata luokan konstruktori.
     * 
     * @param attributeType attribuutin tyyppi
     * @param attributeName attribuutin nimi
     * @param attributeValue attribuutin arvo
     */
    public Metadata(int attributeType, String attributeName, String attributeValue) {
	this(attributeType, attributeName, attributeValue, 0, OperationMode.TALLENNA);
    }


    /**
     * Metadata luokan konstruktori.
     * 
     * @param attributeType attribuutin tyyppi
     * @param attributeName attribuutin nimi
     * @param attributeValues attribuutin arvokokoelma
     */
    public Metadata(int attributeType, String attributeName, List<String> attributeValues) {
	this(attributeType, attributeName, null, attributeValues, true, 0, OperationMode.TALLENNA);
    }


    /**
     * Metadata luokan konstruktori.
     */
    public Metadata() {
	// oletuskonstruktori
    }


    /**
     * Palauttaa attribuuttityypin.
     * 
     * @return attribuuttityyppi
     */
    public int getAttributeType() {
	return attributeType;
    }


    /**
     * Attribuuttityypin asetus.
     * 
     * @param attributeType attribuuttityyppi
     */
    public void setAttributeType(int attributeType) {
	this.attributeType = attributeType;
    }


    /**
     * Palauttaa attribuutin nimen.
     * 
     * @return attribuutin nimi
     */
    public String getAttributeName() {
	return attributeName;
    }


    /**
     * Attribuutin nimen asetus.
     * 
     * @param attributeName attribuutin nimi
     */
    public void setAttributeName(String attributeName) {
	this.attributeName = attributeName;
    }


    /**
     * Palauttaa attribuutin arvon.
     * 
     * @return attribuutin arvo
     */
    public String getAttributeValue() {
	return attributeValue;
    }


    /**
     * Attribuutin arvon asetus.
     * 
     * @param attributeValue attribuutin arvo
     */
    public void setAttributeValue(String attributeValue) {
	this.attributeValue = attributeValue;
    }


    /**
     * Palauttaa attribuutin arvokokoleman.
     * 
     * @return attribuutin arvokokoelma
     */
    public List<String> getAttributeValues() {

	if (attributeValues == null) {
	    attributeValues = new ArrayList<>();
	}

	return attributeValues;
    }


    /**
     * Attribuutin arvokokoelman asetus.
     * 
     * @param attributeValues attribuutin arvokokoelma
     */
    public void setAttributeValues(List<String> attributeValues) {
	this.attributeValues = attributeValues;
    }


    /**
     * Palauttaa tiedon onko attribuutti kokoelmatyyppinen.
     * 
     * @return true jos attribuutti on kokoelmatyyppinen
     */
    public boolean isRepeating() {
	return isRepeating;
    }


    /**
     * Attribuutin kokoelmatyyppitiedon asetus.
     * 
     * @param isRepeating onko attribuutti kokoelmatyyppinen
     */
    public void setRepeating(boolean isRepeating) {
	this.isRepeating = isRepeating;
    }


    /**
     * Palauttaa attribuuttin tietokantakentän maksimipituuden.
     * 
     * @return tietokantakentän maksimipituus
     */
    public int getAttributeFieldLength() {
	return attributeFieldLength;
    }


    /**
     * Attribuutin tietokantakentän maksimipituuden asetus.
     * 
     * @param attributeFieldLength tietokantakentän maksimipituus
     */
    public void setAttributeFieldLength(int attributeFieldLength) {
	this.attributeFieldLength = attributeFieldLength;
    }


    /**
     * Palauttaa metatiedon käsittelyä ohjaavan operaatiotiedon.
     * 
     * @return metatiedon käsittelyä ohjaava operaatiotieto
     */
    public OperationMode getOperationMode() {
	return operationMode;
    }


    /**
     * Metatiedon käsittelyä ohjaavan operaatiotiedon asetus.
     * 
     * @param operationMode metatiedon käsittelyä ohjaava operaatiotieto
     */
    public void setOperationMode(OperationMode operationMode) {
	this.operationMode = operationMode;
    }

}
