package fi.kela.kanta.ptayhteiset.tietomalli.poikkeukset;

/**
 * Luokka sisäisille virheille
 */
public class InternalServiceError extends Throwable {

    private static final long serialVersionUID = -55856654307293394L;

    private final String errorCode;
    private final String errorLevel;
    private final String errorDescription;


    /**
     * Luonti virheviestillä
     * 
     * @param errorMessage virheviesti
     */
    public InternalServiceError(String errorMessage) {
	super(errorMessage);

	this.errorCode = "";
	this.errorLevel = "1";
	this.errorDescription = null;
    }


    /**
     * Luonti toisen instanssin tiedoilla
     * 
     * @param error virheinstanssi
     * @param description lisäselite
     */
    public InternalServiceError(InternalServiceError error, String description) {

	super(error.getMessage());

	if (error.getCause() != null) {
	    super.initCause(error.getCause());
	}

	this.errorCode = error.getErrorCode();
	this.errorLevel = error.getErrorLevel();
	this.errorDescription = description;
    }


    /**
     * Luonti virheviestillä, virhekoodilla ja virhetasolla
     * 
     * @param errorMessage virheviesti
     * @param errorCode virhekoodi
     * @param errorLevel virhetaso
     */
    public InternalServiceError(String errorMessage, String errorCode, String errorLevel) {

	super(errorMessage);

	this.errorCode = errorCode;
	this.errorLevel = errorLevel;
	this.errorDescription = null;
    }


    /**
     * Luonti virheviestillä, virhekoodilla, virhetasolla ja lisäselitteellä
     * 
     * @param errorMessage virheviesti
     * @param errorCode virhekoodi
     * @param errorLevel virhetaso
     * @param errorDescription lisäselite
     */
    public InternalServiceError(String errorMessage, String errorCode, String errorLevel, String errorDescription) {

	super(errorMessage);

	this.errorCode = errorCode;
	this.errorLevel = errorLevel;
	this.errorDescription = errorDescription;
    }


    /**
     * Luonti alkuperäisellä virheellä ja virheviestillä
     * 
     * @param errorCause alkuperäinen virhe
     * @param errorMessage virheviesti
     */
    public InternalServiceError(Throwable errorCause, String errorMessage) {
	super(errorMessage, errorCause);

	this.errorCode = "";
	this.errorLevel = "1";
	this.errorDescription = null;
    }


    /**
     * Luonti alkuperäisellä virheellä, virheviestillä ja virhekoodilla
     * 
     * @param errorCause alkuperäinen virhe
     * @param errorMessage virheviesti
     * @param errorCode virhekoodi
     */
    public InternalServiceError(Throwable errorCause, String errorMessage, String errorCode) {

	super(errorMessage, errorCause);

	this.errorCode = errorCode;
	this.errorLevel = "1";
	this.errorDescription = null;
    }


    /**
     * Luonti alkuperäisellä virheellä, virheviestillä, virhekoodilla ja virhetasolla
     * 
     * @param errorCause alkuperäinen virhe
     * @param errorMessage virheviesti
     * @param errorCode virhekoodi
     * @param errorLevel virhetaso
     */
    public InternalServiceError(Throwable errorCause, String errorMessage, String errorCode, String errorLevel) {

	super(errorMessage, errorCause);

	this.errorCode = errorCode;
	this.errorLevel = errorLevel;
	this.errorDescription = null;
    }


    /**
     * Luonti alkuperäisellä virheellä, virheviestillä, virhekoodilla, virhetasolla ja lisäselitteellä
     * 
     * @param errorCause alkuperäinen virhe
     * @param errorMessage virheviesti
     * @param errorCode virhekoodi
     * @param errorLevel virhetaso
     * @param errorDescription virheen lisäselite
     */
    public InternalServiceError(Throwable errorCause, String errorMessage, String errorCode, String errorLevel, String errorDescription) {

	super(errorMessage, errorCause);

	this.errorCode = errorCode;
	this.errorLevel = errorLevel;
	this.errorDescription = errorDescription;
    }


    /**
     * Palauttaa virhekuvauksen
     * 
     * @return virhekuvaus
     */
    public String getErrorDescription() {
	return errorDescription;
    }


    /**
     * Palauttaa virhekoodin
     * 
     * @return virhekoodi
     */
    public String getErrorCode() {
	return errorCode;
    }


    /**
     * Palauttaa virheviestin
     * 
     * @return virheviesti
     */
    public String getErrorMessage() {
	return super.getMessage();
    }


    /**
     * Palauttaa virhetason
     * 
     * @return virhetaso
     */
    public String getErrorLevel() {
	return errorLevel;
    }
}
