package fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit;

/**
 * Luokka aikarajatiedolle
 */
public class Aikaraja {
    private final String aika;
    private final Boolean inclusive;


    /**
     * Aikaraja-luokan konstruktori, jossa oletuksen raja-arvo mukana hakutuloksessa.
     * 
     * @param aika ajanhetki
     */
    public Aikaraja(final String aika) {
	this.aika = aika;
	this.inclusive = true;
    }


    /**
     * Aikaraja-luokan konstruktori.
     * 
     * @param aika ajan hetki
     * @param inclusive tieto siitä sisältyykö raja-arvo hakutuloksen mukaan
     */
    public Aikaraja(final String aika, final Boolean inclusive) {
	this.aika = aika;
	this.inclusive = inclusive;
    }


    /**
     * Palauttaa ajan.
     * 
     * @return aika
     */
    public String getAika() {
	return aika;
    }


    /**
     * Palauttaa tiedon sisältyykö aika hakurajaukseen mukaan.
     * 
     * @return inclusive
     */
    public Boolean isInclusive() {
	return inclusive;
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
	return "Aikaraja [aika=" + aika + ", inclusive=" + inclusive + "]";
    }
}
