package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * voi tuuppia fieldin arvoja propseista 
 */
public class BeanConfigurer {

    private static final String FAILED_SET_PROPERTY = "failed set property: [{}]";
    private static final String SET_PROPERTY = "set property: [{}]";
    private static final Logger LOG = LoggerFactory.getLogger(BeanConfigurer.class);

    public static void configure(Object o, Properties props) {
        Iterator<Object> propertyIterator = props.keySet().iterator();

        while (propertyIterator.hasNext()) {
            String property = (String) propertyIterator.next();
            String propertyValue = props.getProperty(property);
            LOG.info("found property: [{}]", property);
            PropertyDescriptor pd = getProperty(property, o);
            if (pd == null)
                continue;
            Class<?> clazz = pd.getPropertyType();
            if (clazz == null) {
                LOG.error("could not determine datatype of field: [{}]", property);
                continue;
            }
            Method setter = pd.getWriteMethod();
            set(setter, o, propertyValue, clazz);

        }
    }


    private static void set(Method setter, Object o, String propertyValue, Class<?> clazz) {
        LOG.info(SET_PROPERTY, propertyValue);
        try {
            switch (clazz.getSimpleName()) {
                case "String":
                    setter.invoke(o, propertyValue);
                    break;
                case "float":
                case "Float":
                    setter.invoke(o, Float.valueOf(propertyValue));
                    break;
                case "double":
                case "Double":
                    setter.invoke(o, Double.valueOf(propertyValue));
                    break;
                case "long":
                case "Long":
                    setter.invoke(o, Long.valueOf(propertyValue));
                    break;
                case "Integer":
                case "int":
                    setter.invoke(o, Integer.valueOf(propertyValue));
                    break;
                default:
                    LOG.error("failed set property: [{}], unknown datatype: [{}]", propertyValue,
                            clazz.getSimpleName());
            }
        } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.error(FAILED_SET_PROPERTY, propertyValue, e);
        }

    }


    


    private static PropertyDescriptor getProperty(String property, Object o) {
        try {
            return new PropertyDescriptor(property, o.getClass());
        } catch (IntrospectionException e) {
            LOG.error("count not find field: [{}] in object", property, e);
            e.printStackTrace();
        }
        return null;
    }


    private BeanConfigurer() {
        // ei
    }

}
