package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.LiiketoimintaHelper;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

/**
 * Validaattori virallista hetua varten. Ei tarkista arvoja hetutarkistuskaavan mukaisesti. Tarkastaa vain merkkijonon
 * pituuden ja että alkaa virallisella rootilla.
 */
public class VirallinenHetuValidator implements ConstraintValidator<VirallinenHetuConstraint, String> {

    @Override
    public void initialize(VirallinenHetuConstraint potilaanHetu) {
    }


    @Override
    public boolean isValid(String potilaanHetu, ConstraintValidatorContext cxt) {
	// tarkastaa pituuden ja että alkaa virallisen hetun rootilla
	return LiiketoimintaHelper.isOfficialHetu(potilaanHetu);
    }

}
