package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;

/**
 * Well-formed xml validaattori. Tarkastaa, että xml-parserointi onnistuu voimassaolevien sääntöjen mukaisesti.
 */
@Documented
@Constraint(validatedBy = WellFormedXmlValidator.class)
@Target({ ElementType.METHOD, ElementType.FIELD })
@Retention(RUNTIME)
public @interface WellFormedXmlConstraint {
    
    String message() default "Xml-viestin sisältöä ei hyväksytty";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
