package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.xml;

/**
 * Luokka CDAR2-asiakirjan header rakenteen XPath-lausekkeisiin liittyville vakioille
 */
public class XpathExpressionCDAHeaderConstants {

    // @formatter:off
    
    public static final String EXPRESSION_RECORD_TARGET = "/v3:ClinicalDocument/v3:recordTarget";
    public static final String EXPRESSION_CDA_OFFICIAL_PATIENTID = "/v3:ClinicalDocument/v3:recordTarget/v3:patientRole/v3:id[@root='1.2.246.21']";
    public static final String EXPRESSION_CDA_PATIENT_FAMILY = "/v3:ClinicalDocument/v3:recordTarget/v3:patientRole/v3:patient/v3:name/v3:family";
    public static final String EXPRESSION_CDA_PATIENT_FIRSTNAME = "/v3:ClinicalDocument/v3:recordTarget/v3:patientRole/v3:patient/v3:name/v3:given[@qualifier='CL']";
    public static final String EXPRESSION_CDA_PATIENT_GIVEN_NAMES = "/v3:ClinicalDocument/v3:recordTarget/v3:patientRole/v3:patient/v3:name/v3:given[not(@qualifier)]";
    public static final String EXPRESSION_CDA_PATIENT_PREFIX = "/v3:ClinicalDocument/v3:recordTarget/v3:patientRole/v3:patient/v3:name/v3:prefix[@qualifier='NB']";
    public static final String EXPRESSION_CDA_PATIENT_BIRTHTIME = "/v3:ClinicalDocument/v3:recordTarget/v3:patientRole/v3:patient/v3:birthTime/@value";

    public static final String EXPRESSION_CDA_TITLE = "/v3:ClinicalDocument/v3:title";
    public static final String EXPRESSION_CDA_SPECIFICATION = "/v3:ClinicalDocument/v3:templateId[@root='1.2.246.777.5.1']";

    public static final String EXPRESSION_CDA_ID = "/v3:ClinicalDocument/v3:id";
    public static final String EXPRESSION_CDA_SET_ID = "/v3:ClinicalDocument/v3:setId";
    public static final String EXPRESSION_RELATED_DOCUMENT_RPLC_ID = "/v3:ClinicalDocument/v3:relatedDocument[@typeCode='RPLC']/v3:parentDocument/v3:id";
    public static final String EXPRESSION_RELATED_DOCUMENT_RPLC_SETID = "/v3:ClinicalDocument/v3:relatedDocument[@typeCode='RPLC']/v3:parentDocument/v3:setId";

    public static final String EXPRESSION_CDA_VERSIONNUMBER = "/v3:ClinicalDocument/v3:versionNumber/@value";
    public static final String EXPRESSION_CDA_EFFECTIVE_TIME = "/v3:ClinicalDocument/v3:effectiveTime/@value";
    public static final String EXPRESSION_CDA_CONFIDENTALITY_CODE = "/v3:ClinicalDocument/v3:confidentialityCode[@codeSystem='1.2.246.777.5.99902.2006']/@code";
    public static final String EXPRESSION_CDA_LANGUAGE_CODE = "/v3:ClinicalDocument/v3:languageCode/@code";
    public static final String EXPRESSION_CDA_REPRESENTED_ORG_HOST_ID = "/v3:ClinicalDocument/v3:componentOf/v3:encompassingEncounter/v3:responsibleParty/v3:assignedEntity/v3:representedOrganization/v3:asOrganizationPartOf/v3:id";
    public static final String EXPRESSION_CDA_REPRESENTED_ORG_ID = "/v3:ClinicalDocument/v3:componentOf/v3:encompassingEncounter/v3:responsibleParty/v3:assignedEntity/v3:representedOrganization/v3:id";
    public static final String EXPRESSION_CDA_REPRESENTED_ORG_NAME = "/v3:ClinicalDocument/v3:componentOf/v3:encompassingEncounter/v3:responsibleParty/v3:assignedEntity/v3:representedOrganization/v3:name";
    public static final String EXPRESSION_CDA_CUSTODIAN_ID = "/v3:ClinicalDocument/v3:custodian/v3:assignedCustodian/v3:representedCustodianOrganization/v3:id";
    public static final String EXPRESSION_CDA_REGISTRY = "/v3:ClinicalDocument/v3:code";
    public static final String EXPRESSION_CDA_COPY_TIME = "/v3:ClinicalDocument/v3:copyTime/@value";
    
    // /ClinicalDocument/hl7fi:localHeader-rakenteeseen kohdistuvat xpath-lausekkeet
    public static final String EXPRESSION_LOCAL_HEADER = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']";
    public static final String EXPRESSION_CDA_HL7_RETENTIONPERIOD_CLASS = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='retentionPeriodClass'][@codeSystem='1.2.246.537.5.40158.2008']";
    public static final String EXPRESSION_CDA_HL7_HOMEMUNICIPALITY = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='patientHomeMunicipality']";
    public static final String EXPRESSION_CDA_HL7_FILEFORMAT = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='fileFormat'][@codeSystem='1.2.246.537.5.40179.2008']";
    public static final String EXPRESSION_CDA_HL7_FUNCTION_CODE = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='functionCode']";
    public static final String EXPRESSION_CDA_HL7_DOCUMENTTYPE = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='documentType'][@codeSystem='1.2.246.537.5.5001.2011']";
    public static final String EXPRESSION_CDA_HL7_PATIENT_REGISTRY_SPECIFIER = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='patientRegistrySpecifier']";
    public static final String EXPRESSION_CDA_HL7_PATIENT_REGISTRY_SPECIFIER_NAME = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='patientRegistrySpecifierName']";
    public static final String EXPRESSION_CDA_HL7_SOFTWARESUPPORT = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='softwareSupport']/@product";
    public static final String EXPRESSION_CDA_HL7_SOFTWAREVERSION = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='softwareSupport']/@version";
    public static final String EXPRESSION_CDA_HL7_TABLE_OF_CONTENTS = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='tableOfContents']/*[local-name()='contentsCode']";
    public static final String EXPRESSION_CDA_HL7_ACTIVE_CUSTODIAN = "/*[local-name()='ClinicalDocument']/*[local-name()='localHeader']/*[local-name()='activeCustodian']";
    

    private XpathExpressionCDAHeaderConstants() {
	// yksityinen konstruktori
    }
}
