package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

import java.util.HashMap;
import java.util.Map;

/**
 * Enumeraatio palautettavien tietojen kattavuusarvoille.
 */
public enum PalautettavienTietojenKattavuus {

    // 1 Palautetaan ajantasaiset versiot
    // 2 Palautetaan kaikki versiot
    // 3 Palautetaan ajantas. tiedot ml. omat tiedot
    AJANTASAISET_VERSIOT("1"), KAIKKI_VERSIOT("2"), AJANTASAISET_VERSIOT_JA_OMAT("3");

    private final String value;


    /**
     * Privaatti konstruktori.
     * 
     * @param value arvo
     */
    private PalautettavienTietojenKattavuus(String value) {
	this.value = value;
    }


    /**
     * Palauttaa enumeraation arvon.
     * 
     * @return enumeraation arvo
     */
    public String getValue() {
	return value;
    }

    private static final Map<String, PalautettavienTietojenKattavuus> lookup = new HashMap<>();

    static {
	for (PalautettavienTietojenKattavuus metatietoKohdistus : PalautettavienTietojenKattavuus.values()) {
	    lookup.put(metatietoKohdistus.getValue(), metatietoKohdistus);
	}
    }


    /**
     * Palauttaa enumeraation annetun arvon perusteella.
     * 
     * @param value arvo
     * @return enumeraatio
     */
    public static PalautettavienTietojenKattavuus get(String value) {
	return lookup.get(value);
    }
}
