package fi.kela.kanta.ptayhteiset.tietomalli.poikkeukset;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Luokka PTAYHteisille vakiovirheteksteille
 */
public class ErrorMessages {

    // Oletusvirhekoodi joka annetaan jos muuhun ei pysty.
    public static final String DEFAULT_ERROR_CODE = "9999";

    // Oletusvirheviesti joka annetaan jos muuhun ei pysty.
    public static final String DEFAULT_ERROR_MESSAGE = "Vakava sisäinen virhe.";

    // ORACLE virhekoodit
    public static final String ORACLE_ERROR_CODE_00001 = "ORA-00001"; // ORA-00001 UNIQUE KEY constraint VIOLATED
    
    public static final String ERROR_CODE_1003 = "1003";
    public static final String ERROR_CODE_1010 = "1010"; // Tarvittavaa tietoa ei saatu parsittua sanomasta
    public static final String ERROR_CODE_1017 = "1017";

    
    public static final String ERROR_CODE_2001 = "2001";
    public static final String ERROR_CODE_2005 = "2005";
    public static final String ERROR_CODE_2009 = "2009";
    public static final String ERROR_CODE_2010 = "2010";

    /**
     * Oletusvirhetaso
     */
    public static final String DEFAULT_ERROR_LEVEL = "1";

    private static Map<String, String> errorList = new HashMap<>();

    public static final Map<String, String> ERROR_CODES = Collections.unmodifiableMap(errorList);


    private ErrorMessages() {
	// yksityinen konstruktori
    }

    /**
     * Virhekoodilista
     */
    // @formatter:off
    static {
	errorList.put(DEFAULT_ERROR_CODE, "9999"); // Tuntematon virhe
	errorList.put(ERROR_CODE_1003, "1003"); // Paluusanomaa ei saatu luotua

	errorList.put(ERROR_CODE_1010, "1010"); // Tarvittavaa tietoa ei saatu parsittua sanomasta

	errorList.put(ERROR_CODE_1017, "1017"); // Sisäinen virhe

	errorList.put(ERROR_CODE_2001, "2001"); // Virheellinen päivämäärä
	errorList.put(ERROR_CODE_2005, "2005"); // Virhe viittausten hakemisessa asiakirjasta
	errorList.put(ERROR_CODE_2009, "2009"); // Saapunut sanoma ei ole validi
	errorList.put(ERROR_CODE_2010, "2010"); // Tarvittavaa tietoa ei saatu parsittua sanomasta
    }
    // @formatter:on
}
