package fi.kela.kanta.ptayhteiset.tietomalli.poikkeukset;

import org.slf4j.MDC;

import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.LogUtils;

/**
 * Sovelluksen heittämät ulkoiselta palvelulta palautuneet virheet, jotka peritty RuntimeException luokasta kääritään
 * tähän poikkeusluokkaan
 */
public class ExternalAppException extends AppException {

    private static final long serialVersionUID = 9192346992052359091L;
    private final String detailedMessage;
    private final String logId = MDC.get(LogUtils.CORRELATION_ID);

    /**
     * Luo uuden ExternalAppException poikkeuksen
     * 
     * @param errorCode sisäinen virhekoodi
     * @param detailedMessage tarkennettu virheteksti
     */
    public ExternalAppException(String errorCode, String detailedMessage) {
        super(errorCode);
        this.detailedMessage = detailedMessage;
    }


    /**
     * Luo uuden ExternalAppException poikkeuksen
     * 
     * @param message lisätietoa tapahtuneesta poikkeuksesta
     * @param cause alkuperäisen virheen aiheuttama poikkeus
     * @param errorCode sisäinen virhekoodi
     * @param detailedMessage tarkennettu virheteksti
     */
    public ExternalAppException(String message, Throwable cause, String errorCode, String detailedMessage) {
        super(message, cause, errorCode);
        this.detailedMessage = detailedMessage;
    }


    /**
     * Luo uuden ExternalAppException poikkeuksen
     * 
     * @param message lisätietoa tapahtuneesta poikkeuksesta
     * @param errorCode sisäinen virhekoodi
     * @param detailedMessage tarkennettu virheteksti
     */
    public ExternalAppException(String message, String errorCode, String detailedMessage) {
        super(message, errorCode);
        this.detailedMessage = detailedMessage;
    }


    /**
     * Luo uuden ExternalAppException poikkeuksen
     * 
     * @param cause alkuperäisen virheen aiheuttama poikkeus
     * @param errorCode sisäinen virhekoodi
     * @param detailedMessage tarkennettu virheteksti
     */
    public ExternalAppException(Throwable cause, String errorCode, String detailedMessage) {
        super(cause, errorCode);
        this.detailedMessage = detailedMessage;
    }


    /**
     * Tarkennetun virhetekstin palautus.
     * 
     * @return tarkennettu virheteksti
     */
    public String getDetailedMessage() {
        return detailedMessage;
    }


    /**
     * Yksilöivän lokitunnisteen palautus.
     * 
     * @return yksilöivä lokitunniste
     */
    @Override
    public String getLogId() {
        return logId;
    }
}
