package fi.kela.kanta.ptayhteiset.tietomalli.tietotyypit;

/**
 * Luokka hakuehtojen aikarajoille
 */
public class Aikarajat {
    private final Aikaraja minAika;
    private final Aikaraja maxAika;


    /**
     * Aikarajat luokan konstruktori.
     * 
     * @param minAika minimi aikaraja
     * @param maxAika maksimi aikaraja
     */
    public Aikarajat(final Aikaraja minAika, final Aikaraja maxAika) {
	this.minAika = minAika;
	this.maxAika = maxAika;
    }


    /**
     * Palauttaa minimiajan.
     * 
     * @return minAika
     */
    public Aikaraja getMinAika() {
	return minAika;
    }


    /**
     * Palauttaa maksimiajan.
     * 
     * @return maxAika
     */
    public Aikaraja getMaxAika() {
	return maxAika;
    }


    /**
     * Onko min tai max aika-arvoja asetettu.
     * 
     * @return tieto onko min tai max aika-arvoja asetettu
     */
    public boolean isNotNull() {
	return minAika != null || maxAika != null;
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
	return "Aikarajat [minAika=" + minAika + ", maxAika=" + maxAika + "]";
    }
}
